
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   UTRIP2D.C - Tripe-to-Double Conversion (and vice versa)
// 
//
//   DESCRIPTION
//
//   Functions to convert between triple integers and double floating point
//   values.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\UTRIP2D.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:12   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:58:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:58   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:16:34   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:26   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <math.h>
#include "gentypes.h"

tDOUBLE utrip2dbl (tUTRIPLE *x) {
  tDOUBLE temp;
  temp =  x->data[0];
  temp += (tULONG)x->data[1] * 0x10000UL;
  temp += 65536.0 * (tDOUBLE)((tULONG)x->data[2] * 0x10000UL);
  return temp;
}


tDOUBLE trip2dbl (tTRIPLE *x) {
  tDOUBLE temp;
  temp =  x->data[0];
  temp += (tULONG)x->data[1] * 0x10000UL;

  temp += 65536.0 * (tDOUBLE)((tULONG)(x->data_2 & 0x7FFF) * 0x10000UL);
  
  if ((x->data_2 & 0x8000u) == 0)
  {
    return temp;
  }
  else
  {
    return -temp;
  }
}


void dbl2utrip (tDOUBLE fpval, tUTRIPLE *x)
{
  fpval = fpval + 0.5;

  x->data[2] = (tUSHORT) ((fpval / 65536.0) / 65536.0); 
  x->data[1] = (tUSHORT) ((fpval- (x->data[2]*65536.0*65536.0))/65536.0); 
  x->data[0] = (tUSHORT) (fpval - ((x->data[2]*65536.0*65536.0) +
                                  (x->data[1]*65536.0)));
}


void dbl2trip (tDOUBLE fpval, tTRIPLE *x)
{
  tBOOL neg = FALSE;

  if (fpval < 0.0)
  {
    neg = TRUE;
  }

  fpval = fabs(fpval);

  dbl2utrip (fpval, (tUTRIPLE *) x);


  if (neg)
  {
    x->data_2 = x->data_2 | 0x8000u;
  }
}
